﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Maps.Fields;
using Mdws2ORM.Maps.BaseFields;

namespace Mdws2ORM.Maps.SingleMaps
{
    public static class SingleMapFactory
    {

        public static Action<Container<V>, V> GetMapAction<V>()
        {
            return (c, e) => c.Item = e;
        }

        public static SingleEntityMap<V> MakeEntityMap<V>(BaseFieldMap<Container<V>> fieldMap, string file, string location)
        {
            return new SingleEntityMap<V>(fieldMap, file, location);
        }

        public static SingleSubEntityMap<V> MakeSubEntityMap<V>(BaseFieldMap<Container<V>> fieldMap, string file)
        {
            return new SingleSubEntityMap<V>(fieldMap, file);
        }

        public static SingleEntityMap<string> MakeStringEntityMap(string file, string location, string field = ".01")
        {
            return MakeEntityMap(new FreeTextFieldMap<Container<string>>(field, GetMapAction<string>()), file, location);
        }

        public static SingleEntityMap<DateTime> MakeDateTimeEntityMap(string file, string location, string field = ".01")
        {
            return MakeEntityMap(new DateTimeFieldMap<Container<DateTime>>(field, GetMapAction<DateTime>()), file, location);
        }

        public static SingleSubEntityMap<string> MakeStringSubEntityMap(string file, string field = ".01")
        {
            return MakeSubEntityMap(new FreeTextFieldMap<Container<string>>(field, GetMapAction<string>()), file);
        }

        public static SingleSubEntityMap<DateTime> MakeDateTimeSubEntityMap(string file, string field = ".01")
        {
            return MakeSubEntityMap(new DateTimeFieldMap<Container<DateTime>>(field, GetMapAction<DateTime>()), file);
        }
    }
}
